//
//  AText.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AText_h
#define AText_h

// AText.h
#import <Foundation/Foundation.h>
#import <UniPRT/IText.h>

/**
 * @class AText
 * @ingroup Interface
 *
 * @~english
 * @brief Base class for AText.
 *
 * @~chinese
 * @brief AText 的基类。
 *
 * @~chinese_traditional
 * @brief AText 的基類。
 */

@interface AText : NSObject <IText>

@property (nonatomic, strong) NSMutableArray<id<ITextItem>> *text;
@property (nonatomic, strong) id<IRuler> ruler;
@property (nonatomic, strong) NSString *fontName;
@property (nonatomic, assign) FontStyleEnum fontStyle;
@property (nonatomic, assign) FontSizeUnitsEnum fontSizeUnits;
@property (nonatomic, assign) AlignEnum alignment;
@property (nonatomic, assign) RotateEnum rotation;

- (instancetype)initWithTextItem:(id<ITextItem>)textItem;
- (NSString *)description;
@end


#endif /* AText_h */
