//
//  ADataMatrix.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ADataMatrix_h
#define ADataMatrix_h
#import <Foundation/Foundation.h>
#import <UniPRT/ISquareCell.h>
#import <UniPRT/ABarcode2D.h>
#import <UniPRT/IPoint.h>

/**
 * @~english
 * @class ADataMatrix
 * @brief Base class for ADataMatrix.
 * @ingroup Interface
 *
 * @~chinese
 * @class ADataMatrix
 * @brief ADataMatrix 的基类。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @class ADataMatrix
 * @brief ADataMatrix 的基類。
 * @ingroup Interface
 */
@interface ADataMatrix : ABarcode2D <ISquareCell>

@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) char ctrlCharDelimiter;
@property (nonatomic, strong) id<ICellSquare> cellSize;

/**
 * @~english
 * @brief Sets the shape for barcode to be rectangular shape, otherwise default square shape is used.
 *
 * @~chinese
 * @brief 设置条码的形状为矩形，否则使用默认的正方形。
 *
 * @~chinese_traditional
 * @brief 設置條碼的形狀為矩形，否則使用默認的正方形。
 */
@property (nonatomic, assign) BOOL rectangle;

/**
 * @~english
 * @brief Get a string that represents the FNC1 character in order to include it within the barcode data.
 *
 * @~chinese
 * @brief 获取一个表示FNC1字符的字符串，以便将其包含在条码数据中。
 *
 * @~chinese_traditional
 * @brief 獲取一個表示FNC1字符的字符串，以便將其包含在條碼數據中。
 */
@property (nonatomic, readonly) NSString *fnc1;

/**
 * @~english
 * @brief Specify the number of cells in terms of rows and columns of the barcode if want to manually set the barcode matrix dimensions.
 *
 * Must specify valid values for rows and columns based on square or rectangular shape selected by Rectangle.
 *
 * Valid Square dimensions (row & col): 10, 12, 14, 16, 18, 20, 22, 24, 26, 32, 36, 40, 44, 48, 52, 64, 72, 80, 88, 96, 104, 120, 132, 144
 *
 * Valid Rectangle dimensions (row x col): 8x18, 8x32, 12x26, 12x36, 16x36, 16x48
 *
 * @~chinese
 * @brief 如果希望手动设置条码矩阵的尺寸，请指定条码的行和列的单元格数量。
 *
 * 必须根据由 Rectangle 选择的方形或矩形形状指定行和列的有效值。
 *
 * 有效的正方形尺寸（行和列）：10, 12, 14, 16, 18, 20, 22, 24, 26, 32, 36, 40, 44, 48, 52, 64, 72, 80, 88, 96, 104, 120, 132, 144
 *
 * 有效的矩形尺寸（行x列）：8x18, 8x32, 12x26, 12x36, 16x36, 16x48
 *
 * @~chinese_traditional
 * @brief 如果希望手動設置條碼矩陣的尺寸，請指定條碼的行和列的單元格數量。
 *
 * 必須根據由 Rectangle 選擇的方形或矩形形狀指定行和列的有效值。
 *
 * 有效的正方形尺寸（行和列）：10, 12, 14, 16, 18, 20, 22, 24, 26, 32, 36, 40, 44, 48, 52, 64, 72, 80, 88, 96, 104, 120, 132, 144
 *
 * 有效的矩形尺寸（行x列）：8x18, 8x32, 12x26, 12x36, 16x36, 16x48
 */
@property (nonatomic, strong) NSValue *rowsCols; // Use NSValue to hold a tuple of int values

- (instancetype)init;
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * @~english
 * @brief Gets a string that represents non-printable control character in 0-31 range.
 *
 * This is useful when need to include non-printable characters within the barcode data. e.g. End Of Line characters 0x0D (CR) or 0x0A (LF) with decimal values 13 or 10 respectively.
 *
 * @~chinese
 * @brief 获取表示 0-31 范围内不可打印控制字符的字符串。
 *
 * 当需要在条码数据中包含不可打印字符时，这非常有用。例如，行尾字符 0x0D (CR) 或 0x0A (LF)，其十进制值分别为 13 或 10。
 *
 * @~chinese_traditional
 * @brief 獲取表示 0-31 範圍內不可打印控制字符的字符串。
 *
 * 當需要在條碼數據中包含不可打印字符時，這非常有用。例如，行尾字符 0x0D (CR) 或 0x0A (LF)，其十進制值分別為 13 或 10。
 */
- (NSString *)ctrlChar:(int)decimalCharValue;

@end

#endif /* ADataMatrix_h */
