//
//  PglTranslate.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglTranslate_h
#define PglTranslate_h

#import <Foundation/Foundation.h>

#import <UniPRT/RotateEnum.h>
#import <UniPRT/AlignEnum.h>
#import <UniPRT/BarcodeTypeEnum_1D.h>
#import <UniPRT/QRCodeModelEnum.h>
#import <UniPRT/QRCodeErrorCorrectionEnum.h>
#import <UniPRT/QRCodeManualEncodingEnum.h>
#import <UniPRT/RfidMemBlockEnum.h>
#import <UniPRT/RfidPasswordTypeEnum.h>
#import <UniPRT/PGL.h>

/** @cond */

@interface PglTranslate : NSObject

+ (PGLRotation)rotationWithEnum:(RotateEnum)rotation;
+ (PGLAlignEnum)alignmentWithEnum:(AlignEnum)align;
+ (PGLBarcodeType1D)barcodeType1DWithEnum:(BarcodeTypeEnum1D)barcodeType;
+ (int)qrCodeModelWithEnum:(QRCodeModelEnum)model;
+ (int)qrCodeErrorCorrectionWithEnum:(QRCodeErrorCorrectionEnum)ErrCorr;
+ (char)qrCodeEncodingWithEnum:(QRCodeManualEncodingEnum)manualEncodeType;
+ (NSString *)rfidMemBlockWithEnum:(RfidMemBlockEnum)memBlockSelect;
+ (NSString *)rfidLockTypeWithEnum:(RfidPasswordTypeEnum)lockType;

@end

#endif /* PglTranslate_h */

/** @endcond */
