//
//  JsonMng.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/3.
//

#ifndef JsonMng_h
#define JsonMng_h


#endif /* JsonMng_h */


#import <Foundation/Foundation.h>
#import <AutoIdSDK/JsonStringTokenizer.h>
#import <AutoIdSDK/JsonStringBuilder.h>
#import <AutoIdSDK/ImpChannel.h>
#import <AutoIdSDK/CancellationToken.h>
#import <AutoIdSDK/TcpComm.h>

@interface JsonComm : NSObject {
    BOOL disposed;
    NSLock *_listenerMutex;
    NSMutableDictionary *_SolicitedListenerTable;
    NSMutableArray *_msgListeners_Solicited;
    CancellationToken *_cancellationTokenSource;
    JsonStringTokenizer *_jsonStringTokenizer;
    NSThread *_asyncJsonMsgTransceiverThread;
    
    BOOL _Connected;
    NSMutableArray *_msgListeners_AllMsgs;
    NSMutableArray *_msgListeners_Unsolicited;
    NSMutableString *_jsonReceived;
    NSLock *_semaphoreListeners;
    
//    id _commToPtr;
    NSInteger _iCommTyp;
}
typedef NS_ENUM(NSInteger, CommType) {
//    USB_COMM,
    BT_COMM,
    TCP_COMM
    // 可以添加更多的通信类型
};

@property (strong, nonatomic) id commToPtr;
@property (assign, nonatomic) CommType commType;
@property (assign, nonatomic) BOOL m_ThIsRunning;

@property (nonatomic, strong) NSMutableArray *msgListeners_Solicited;
@property (nonatomic, strong) NSMutableArray *msgListeners_Unsolicited;
@property (nonatomic, strong) NSMutableArray *msgListeners_AllMsgs;
@property (nonatomic, strong) NSMutableDictionary<NSString *, ImpChannel *> *solicitedListenerTable;
@property (nonatomic, strong) ImpChannel * msgOut;
@property (nonatomic, strong) ImpChannel * MonitorMsgOut;
@property (nonatomic, strong) ImpChannel * MsgsFromPtr;
@property (nonatomic, assign) BOOL usingDataPort;
@property (nonatomic, strong) NSString *solicitedUnsolicitedMsg;
@property (nonatomic, assign) NSInteger iMsgCount;

typedef NS_ENUM(NSInteger, ChannelType)
{
    // msgs that have a requestID. e.g. response from printer to msg that had a requestID.
    SOLICITED_MSGS_ONLY,
    // msgs that don't have a requestID. e.g. ODV/RFID/Label/Engine reports/status
    UNSOLICITED_MSGS_ONLY,
    // All msgs. Unfiltered.  If it's a fully formed Mgmt msg, this channel type will get it.
    ALL_MSGS
};

//- (void)initializeWithCommToPtr:(id)commToPtr commType:(int)commType;
- (void)dispose;
- (void)disposeWithFlag:(BOOL)disposing;
- (void)listenerChannelDisconnect:(ImpChannel *)chnlToRemove;
- (void)start;
- (void)stop;
- (void)stopEx;
- (void)jsonMsgTransceiverTask;
- (NSString *)solicitedChnlKey:(ImpChannel *)chnlToLookFor;
- (instancetype)initWithComm:(id)commToPtr commType:(NSInteger)commType;
- (ImpChannel *)listenerChannelGetNewWithCapacity:(NSInteger)capacity
                                      channelType:(ChannelType)channelType
                                   solicitedMsgId:(NSString *)solicitedMsgId;
- (void)send:(NSString *)mgmtMsgToSend;
- (ImpChannel *)getImpChannel;
- (TcpComm *)getPtrComm;
- (NSString *)sendAndWaitForResponse:(NSString *)mgmtMsg timeout:(int)respTimeoutMs;

@end
