//
//  btComm.h
//  sdk_json_Objective-C_IOS
//
//  Created by Realbuber on 2024/4/23.
//

#ifndef btComm_h
#define btComm_h


#endif /* btComm_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/AComm.h>
#import <ExternalAccessory/ExternalAccessory.h>

@interface BtComm : AComm <NSStreamDelegate>

@property (strong, nonatomic) NSInputStream *inputStream;
@property (strong, nonatomic) NSOutputStream *outputStream;
@property (nonatomic, readwrite) BOOL connected;

- (instancetype)initWithDeviceAddress:(NSString *)deviceAddress;
- (void)open;
- (void)close;
- (void)write:(NSData *)text;
- (NSData *)read;
- (NSData *)writeAndWaitForResponse:(NSData *)text
                 responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                   responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                      completionToken:(NSString *)completionToken;

- (void)stream:(NSStream *)aStream handleEvent:(NSStreamEvent)eventCode;

@end
