﻿// TestCommSDK.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <cstdint>
#include <Windows.h>
#include <tchar.h>


enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};

typedef unsigned char byte;


typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef byte* (__stdcall* PWRITEANDWAITFORRESPONSE)(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);


PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PTCPCONNECT pTcpConnect = NULL;
PWRITEANDWAITFORRESPONSE pWriteAndWaitForResponse = NULL;

HINSTANCE m_SdkDLL = NULL;

bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;




void ListenerAsync()
{

    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(500));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);


        int iBytes = pBytesAvailable();
        byte* pBuf = nullptr;

        if (!_bAsyncListening)
            break;

        if (iBytes > 0) {

            pBuf = new byte[iBytes];
            pRead(pBuf, iBytes);

            if (!_bAsyncListening)
            {
                delete[] pBuf;
                pBuf = nullptr;
                break;
            }

            std::string str(reinterpret_cast<char*>(pBuf), iBytes);
            currentText += str;
            std::cout << std::endl;
            std::cout << std::endl;
            std::cout << "Response:";
            std::cout << currentText << std::endl;

            delete[] pBuf;
            pBuf = nullptr;
            
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen()
{
    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}

int main()
{
	m_SdkDLL = LoadLibrary(_T("CommSDK.dll"));

	if (m_SdkDLL == NULL)
	{
		std::cout << "Load CommSDK.dll failed!" << std::endl;
		return 1;
	}

    pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_SdkDLL, "BytesAvailable");
	pConnected = (PCONNECTED)GetProcAddress(m_SdkDLL, "Connected");
	pRead = (PREAD)GetProcAddress(m_SdkDLL, "Read");
	pWrite = (PWRITE)GetProcAddress(m_SdkDLL, "Write");
	pClose = (PCLOSE)GetProcAddress(m_SdkDLL, "Close");
	pOpen = (POPEN)GetProcAddress(m_SdkDLL, "Open");
	pTcpConnect = (PTCPCONNECT)GetProcAddress(m_SdkDLL, "TcpConnect");
	pWriteAndWaitForResponse = (PWRITEANDWAITFORRESPONSE)GetProcAddress(m_SdkDLL, "WriteAndWaitForResponse");


	if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
		pClose == NULL || pWrite == NULL || pTcpConnect == NULL || pWriteAndWaitForResponse == NULL)
	{
		std::cout << "Load the CommSDK.dll APIs failed!" << std::endl;
        if (m_SdkDLL != NULL)
            FreeLibrary(m_SdkDLL);
		return 1;
	}

    
    pTcpConnect((char*)"10.0.10.173", 9100);
   
    pOpen();

    if (pConnected())
    {
        std::string content;

        // Print Job

        
        content += "SIZE 3,2\r\n";
        content += "GAP 0 mm, 0 mm\r\n";
        content += "DIRECTION 1\r\n";
        content += "CLS\r\n";
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n";
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n";
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n";
        content += "PRINT 1, 1\r\n";
        
        

        /*
        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB - START; 1234\r\n";
        content += "PTX_END\r\n";

        content += "~NORMAL\r\n";

        content += "~CREATE; PTX; 432\r\n";
        content += "ALPHA\r\n";
        content += "5.7; 8; 1; 1; *PRINTRONIX*\r\n";
        content += "STOP\r\n";
        content += "BARCODE\r\n";
        content += "DATAMATRIX; 2; 10\r\n";
        content += "*PRINTRONIX*\r\n";
        content += "STOP\r\n";
        content += "END\r\n";
        content += "~EXECUTE; PTX; 1\r\n";

        content += "~NORMAL\r\n";

        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB - END; 1234\r\n";
        content += "PTX_END\r\n";
        */


        // Print Job


        
        //AsyncListen
        /*
        RunAsyncListen();
        content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n";
        content += "OUT A$\r\n";
        */
        //AsyncListen
        
        
        
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        pWrite((byte*)pStr, (int)strlen(pStr));
        


        /*
        // WriteAndWaitForResponse
        content += "FEED 100\r\n";
        content += "OUT \"12345678\"\r\n";
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        byte* pResponse = pWriteAndWaitForResponse((byte*)pStr, content.size(), 1000, 500, (char*)"\r\n");
        std::string str(reinterpret_cast<char*>(pResponse), strlen(reinterpret_cast<char*>(pResponse)));
        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Response:";
        std::cout << str << std::endl;
        // WriteAndWaitForResponse
        */


    }
    else
    {
        std::cout << "Failed to Connect Printer!" << std::endl;
        if (m_SdkDLL != NULL)
            FreeLibrary(m_SdkDLL);
        return 1;
    }

    
    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;

    pClose();

    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }

          
    if (m_SdkDLL != NULL)
        FreeLibrary(m_SdkDLL);

    
	return 0;



}

