//
//  IPrintPlane.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef IPrintPlane_h
#define IPrintPlane_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPrintResolution.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/IPoint.h>

/** @cond **/

@protocol IPrintPlane <NSObject>
@property (nonatomic, strong) id<IPrintResolution> printerResolution;
@property (nonatomic, strong) id<IRuler> ruler;

- (float)dotsPerUnitWithRuler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)dotsToPointsWithDots:(float)dots resolution:(id<IPrintResolution>)resolution;
- (float)inchToDotsWithInchValue:(float)inchValue resolution:(id<IPrintResolution>)resolution;
- (float)inchToPointsWithInchValue:(float)inchValue resolution:(id<IPrintResolution>)resolution;
- (float)mmToDotsWithMMValue:(float)mmValue resolution:(id<IPrintResolution>)resolution;
- (float)mmToPointsWithMMValue:(float)mmValue resolution:(id<IPrintResolution>)resolution;
- (float)toPointsWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toDotsWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toInchWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (float)toMMWithScaledNumber:(float)scaledNumber ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
- (id<IPoint>)toDotsWithScaledPosition:(id<IPoint>)scaledPosition ruler:(id<IRuler>)ruler resolution:(id<IPrintResolution>)resolution;
@end

/** @endcond **/

#endif /* IPrintPlane_h */
