//
//  AMaxicodeMsg.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AMaxicodeMsg_h
#define AMaxicodeMsg_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/IMaxicodeMsg.h>

@interface AMaxicodeMsg : NSObject <IMaxicodeMsg>

@property (nonatomic, assign) MaxicodeModeEnum mode; // Using specific enum type instead of general Enum
@property (nonatomic, copy) NSString *primaryMsg;
@property (nonatomic, copy) NSString *remainingMsg;
@property (nonatomic, readonly, copy) NSString *data;

- (instancetype)init;
- (instancetype)initWithMode:(MaxicodeModeEnum)mode primaryMsg:(NSString *)primaryMsg remainingMsg:(NSString *)remainingMsg NS_DESIGNATED_INITIALIZER;

@end

#endif /* AMaxicodeMsg_h */
