//
//  OdvReport.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef OdvReport_h
#define OdvReport_h


#endif /* OdvReport_h */
// OdvReport.h

#import <Foundation/Foundation.h>

/**
 * @class OdvReport
 * @brief A class for managing Optical Disc Verification (ODV) report information.
 * @ingroup Monitor
 */
@interface OdvReport : NSObject

// Public properties and methods

/**
 * @brief Checks if the ODV operation failed.
 *
 * @return YES if the operation failed, NO otherwise.
 */
- (BOOL)failed;

/**
 * @brief Gets the data from the ODV report.
 *
 * @return A string representing the ODV data.
 */
- (NSString *)data;

/**
 * @brief Gets the overall grade from the ODV report.
 *
 * @return A string representing the overall grade.
 */
- (NSString *)overallGrade;

/**
 * @brief Gets the overall grade as a letter from the ODV report.
 *
 * @return A string representing the overall grade letter.
 */
- (NSString *)overallGradeLetter;

/**
 * @brief Gets the overall grade as a float from the ODV report.
 *
 * @return A float representing the overall grade.
 */
- (float)overallGradeAsFloat;

/**
 * @brief Gets the symbology from the ODV report.
 *
 * @return A string representing the symbology.
 */
- (NSString *)symbology;

/**
 * @brief Sets the raw report dictionary.
 *
 * @param rawreport The dictionary containing the raw ODV report information.
 */
- (void)setRawReport:(NSDictionary<NSString *, NSString *> *)rawreport;

/**
 * @brief Decodes a Base64 encoded string.
 *
 * @param encodedString The Base64 encoded string to decode.
 * @return A decoded string.
 */
- (NSString *)base64Decode:(NSString *)encodedString;

@end
