//
//  PrinterUtil.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/11.
//

#ifndef PrinterUtil_h
#define PrinterUtil_h
#endif /* PrinterUtil_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/SimplePing.h>

/**
 * @class PrinterUtil
 * @brief A utility class for printer-related operations such as pinging.
 * @ingroup Monitor
 */
@interface PrinterUtil : NSObject

/**
 * @brief Pings a printer at the specified IP address and checks if it responds within the given timeout.
 *
 * @param ip The IP address of the printer to ping.
 * @param timeoutSecs The timeout period in seconds.
 * @return YES if the printer responds within the timeout period, NO otherwise.
 */
- (BOOL)pingRespondedWithIp:(NSString *)ip timeoutSecs:(int)timeoutSecs;

/**
 * @brief Pings a printer at the specified IP address and checks if it stops responding within the given timeout.
 *
 * @param ip The IP address of the printer to ping.
 * @param timeoutSecs The timeout period in seconds.
 * @return YES if the printer stops responding within the timeout period, NO otherwise.
 */
- (BOOL)pingStoppedRespondingWithIp:(NSString *)ip timeoutSecs:(int)timeoutSecs;

@end
