//
//  Barcode2D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/13.
//

#ifndef Barcode2D_h
#define Barcode2D_h

#import <Foundation/Foundation.h>

#import <UniPRT/TSPL.h>
#import <UniPRT/TsplCmd.h>
#import <UniPRT/Barcode2DProperties.h>

/** @cond */

@interface Barcode2D : NSObject

@property (nonatomic, assign) TSPLBarcodeType2D bcdType;
@property (nonatomic, assign) int SR;
@property (nonatomic, assign) int SC;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, assign) TSPLRotation rotation;

- (instancetype)initWithBcdType:(TSPLBarcodeType2D)bcdType SR:(int)sr SC:(int)sc Data:(NSString *)data;
- (instancetype)initWithBcdProps:(Barcode2DProperties *)bcdProps SR:(int)sr SC:(int)sc Data:(NSString *)data;

- (NSString *)description;

@end

/** @endcond */

#endif /* Barcode2D_h */
