//
//  PglDataMatrixBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglDataMatrixBarcode_h
#define PglDataMatrixBarcode_h

#import <Foundation/Foundation.h>

#import <UniPRT/ADataMatrix.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/PglCmd.h>
#import <UniPRT/PglTranslate.h>
#import <UniPRT/PGL.h>

/**
 * \~English
 * @class PglDataMatrixBarcode
 * @brief A class representing a Data Matrix barcode.
 *
 * This class inherits from ADataMatrix and provides functionality for initializing and describing Data Matrix barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglDataMatrixBarcode
 * @brief 表示数据矩阵条形码的类。
 *
 * 该类继承自ADataMatrix并提供了初始化和描述数据矩阵条形码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglDataMatrixBarcode
 * @brief 表示數據矩陣條形碼的類。
 *
 * 該類繼承自ADataMatrix並提供了初始化和描述數據矩陣條形碼的功能。
 *
 * @ingroup PGL
 */
@interface PglDataMatrixBarcode : ADataMatrix

/**
 * \~English
 * @brief Initializes a new instance of the PglDataMatrixBarcode class.
 *
 * @return A new instance of PglDataMatrixBarcode.
 *
 * \~Chinese
 * @brief 初始化PglDataMatrixBarcode类的新实例。
 *
 * @return PglDataMatrixBarcode的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化PglDataMatrixBarcode類的新實例。
 *
 * @return PglDataMatrixBarcode的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the PglDataMatrixBarcode class with the specified start point and data.
 *
 * @param start The starting point of the barcode.
 * @param data The data to be encoded in the barcode.
 * @return A new instance of PglDataMatrixBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化PglDataMatrixBarcode类的新实例。
 *
 * @param start 条形码的起始点。
 * @param data 要编码到条形码中的数据。
 * @return PglDataMatrixBarcode的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化PglDataMatrixBarcode類的新實例。
 *
 * @param start 條形碼的起始點。
 * @param data 要編碼到條形碼中的數據。
 * @return PglDataMatrixBarcode的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * \~English
 * @brief Returns a string that describes the contents of the receiver.
 *
 * @return A string description of the PglDataMatrixBarcode instance.
 *
 * \~Chinese
 * @brief 返回一个描述接收者内容的字符串。
 *
 * @return PglDataMatrixBarcode实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回一個描述接收者內容的字符串。
 *
 * @return PglDataMatrixBarcode實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglDataMatrixBarcode_h */
