﻿package com.test.AutoIdSdk;

import java.util.Arrays;
import com.AutoId.Sdk.Json.OdvMonitor;
import com.AutoId.Sdk.Json.OdvReport;

public class OdvMonitorSnippet {

    private static OdvMonitor _odvReportListener = null;

    public static void main(String[] args) {
        System.out.println("Listening for ODV barcode reports.");
        try {
            //_odvReportListener = new OdvMonitor("127.0.0.1");
            _odvReportListener = new OdvMonitor("192.168.1.55");

            _odvReportListener.SetOdvReportListening(true);   // enable parsing of unsolicited barcode report msgs from printer
            _odvReportListener.SetOdvReportCallback(OdvMonitorSnippet::myOdvReportProcessing);  // set the callback/delegate to call when reports received

            while (true) {   // wait for something to happen
                // pretend to be busy doing some other work here...
                Thread.sleep(1000); // simulate work
            }
        } catch (Exception e) {
            System.out.printf("Exception Msg: %s%n", e.getMessage());
        } finally {
            if (_odvReportListener != null) {
                _odvReportListener.Dispose();
            }
        }
    }

    public static void myOdvReportProcessing(OdvReport odvReport) {
        // Could also customize into CSV format based on needs
        String userFriendlyResult = odvReport.Failed() ? "failed" : "passed"; // failure output as "failed"/"passed" to make more user friendly
        System.out.println("\r\nShort CSV Format (customized ordered list): pass/fail, Grade, Data");
        System.out.printf("  %s, %s, %s%n", userFriendlyResult, odvReport.OverallGrade(), odvReport.Data());
    }
}
