﻿// MIT License
//
// Copyright (c) [2019] [Printronix Auto ID Technology, Inc.]
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

using System;
using System.Runtime.InteropServices;
public class PTXLIB
{ 
    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_DLLinit")]
    public static extern void PTXA_DLLinit();

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_DLLexit")]
    public static extern void PTXA_DLLexit();

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetDllVersion")]
    public static extern IntPtr PTXA_GetDllVersion();

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrinterReset")]
    public static extern IntPtr PTXA_PrinterReset();

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetupStatus")]
    public static extern int PTXA_SetupStatus(int mode);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetStatus")]
    public static extern IntPtr PTXA_GetStatus();

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_JobSetup")]
    public static extern int PTXA_JobSetup(int mode, int value);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_CreateForm")]
    public static extern int PTXA_CreateForm(string FormName);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_FormSetup")]
    public static extern int PTXA_FormSetup(int mode, int value);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_Scale")]
    public static extern int PTXA_Scale(int hdpi, int vdpi);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_DrawBox")]
    public static extern int PTXA_DrawBox(int lForm, int LT, int SR, int SC, int ER, int EC);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_DrawLine")]
    public static extern int PTXA_DrawLine(int lForm, int LT, int SR, int SC, int ER, int EC);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintTextEng")]
    public static extern int PTXA_PrintTextEng(int lForm, int SR, int SC, int VE, int HE, string data);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintTextCH")]
    public static extern int PTXA_PrintTextCH(int lForm, int SR, int SC, int VE, int HE, string data);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintImage")]
    public static extern int PTXA_PrintImage(int lForm, int SR, int SC, string logoname);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetBarcode")]
    public static extern int PTXA_SetBarcode(int BcdType, int mode, string value);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintBarcode")]
    public static extern int PTXA_PrintBarcode(int lForm, int BcdType, int SR, int SC, string data);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintForm")]
    public static extern IntPtr PTXA_PrintForm(int lForm);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetFormData")]
    public static extern IntPtr PTXA_GetFormData(int lForm);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetupRFID")]
    public static extern int PTXA_SetupRFID(int length, bool incremental, string format, int increment_amount, string data);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_WriteRFID")]
    public static extern int PTXA_WriteRFID(int lForm, string LOCK, string membank);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_VerifyRFID")]
    public static extern int PTXA_VerifyRFID(int lForm, string UNLOCK, string membank, int length, string format);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_FontSetup")]
    public static extern int PTXA_FontSetup(int mode, string value);

    [DllImport("PTXLIB.dll", EntryPoint = "PTXA_Read")]
    public static extern IntPtr PTXA_Read();

    [DllImport("PTXLIB.dll", EntryPoint = "about")]
    public static extern int about();

    [DllImport("PTXLIB.dll", EntryPoint = "openport")]
    public static extern int openport(string printername);

	[DllImport("PTXLIB.dll", EntryPoint = "openethernet")]
	public static extern int openethernet(string ipaddress, int portnumber);

    [DllImport("PTXLIB.dll", EntryPoint = "closeport")]
    public static extern int closeport();

    [DllImport("PTXLIB.dll", EntryPoint = "sendcommand")]
    public static extern int sendcommand(string printercommand);
}

