// MIT License
//
// Copyright (c) [2019] [Printronix Auto ID Technology, Inc.]
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

using namespace System::Runtime::InteropServices; // for DllImportAttribute

namespace PTXLIB
{
	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_DLLinit")]
	void PTXA_DLLinit();

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_DLLexit")]
	void PTXA_DLLexit();

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetDllVersion")]
	char * PTXA_GetDllVersion();

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrinterReset")]
	char * PTXA_PrinterReset();

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetupStatus")]
	int PTXA_SetupStatus(int mode);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetStatus")]
	char * PTXA_GetStatus();

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_JobSetup")]
	int PTXA_JobSetup(int mode, int value);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_CreateForm")]
	int PTXA_CreateForm(char* FormName);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_FormSetup")]
	int PTXA_FormSetup(int mode, int value);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_Scale")]
	int PTXA_Scale(int hdpi, int vdpi);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_DrawBox")]
	int PTXA_DrawBox(int lForm, int LT, int SR, int SC, int ER, int EC);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_DrawLine")]
	int PTXA_DrawLine(int lForm, int LT, int SR, int SC, int ER, int EC);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintTextEng")]
	int PTXA_PrintTextEng(int lForm, int SR, int SC, int VE, int HE, char* data);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintTextCH")]
	int PTXA_PrintTextCH(int lForm, int SR, int SC, int VE, int HE, char* data);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintImage")]
	int PTXA_PrintImage(int lForm, int SR, int SC, char* logoname);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetBarcode")]
	int PTXA_SetBarcode(int BcdType, int mode, char* value);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintBarcode")]
	int PTXA_PrintBarcode(int lForm, int BcdType, int SR, int SC, char* data);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_PrintForm")]
	char * PTXA_PrintForm(int lForm);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_GetFormData")]
	char * PTXA_GetFormData(int lForm);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_SetupRFID")]
	int PTXA_SetupRFID(int length, bool incremental, char* format, int increment_amount, char* data);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_WriteRFID")]
	int PTXA_WriteRFID(int lForm, char* LOCK, char* membank);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_VerifyRFID")]
	int PTXA_VerifyRFID(int lForm, char* UNLOCK, char* membank, int length, char* format);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_FontSetup")]
	int PTXA_FontSetup(int mode, char* value);

	[DllImport("PTXLIB.dll", EntryPoint = "PTXA_Read")]
	char * PTXA_Read(char * EndSymbol);

	[DllImport("PTXLIB.dll", EntryPoint = "about")]
	int about();

	[DllImport("PTXLIB.dll", EntryPoint = "openport")]
	int openport(char * printername);
	
	[DllImport("PTXLIB.dll", EntryPoint = "openethernet")]
	int openethernet(char * ipaddress, int portnumber);

	[DllImport("PTXLIB.dll", EntryPoint = "closeport")]
	int closeport();

	[DllImport("PTXLIB.dll", EntryPoint = "sendcommand")]
	int sendcommand(char * printercommand);

}