﻿// MIT License
//
// Copyright (c) [2019] [Printronix Auto ID Technology, Inc.]
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

using System;
using System.Windows.Forms;

using System.Runtime.InteropServices;

namespace PTX_DLL_TEST
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // This function is called by a function of the developer's choosing and will print
        // a label to a Printronix printer as represented in the C# directory called
        // PTXTestCode.jpg.

        private void button1_Click(object sender, EventArgs e)
        {
            /* OPEN THE CONNECTION TO USB */
            PTXLIB.openport("USB");

            /* INIT THE DLL */
            PTXLIB.PTXA_DLLinit();

            // Coordinates are in units of 10 cpi, 6 lpi
            PTXLIB.PTXA_Scale(10, 6);

            // No sensor will be used for this job (e.g., continuous mode)
            PTXLIB.PTXA_JobSetup(PTX_Constants.PTXA_JobModeLabel, PTX_Constants.PTXA_JobLabelNoSensor);

            // Rotation of label is portrait
            PTXLIB.PTXA_JobSetup(PTX_Constants.PTXA_JobModeRotate, PTX_Constants.PTXA_JobRotatePort);

            // Create the label object
            int lForm = PTXLIB.PTXA_CreateForm("TestForm");
            Console.WriteLine("Form Number:" + lForm);

            /* BOX */
            PTXLIB.PTXA_DrawBox(lForm, 2, 3, 4, 30, 30);

            /* HORZ LINES */
            PTXLIB.PTXA_DrawLine(lForm, 1, 14, 4, 14, 30);
            PTXLIB.PTXA_DrawLine(lForm, 1, 19, 4, 19, 30);
            PTXLIB.PTXA_DrawLine(lForm, 1, 24, 4, 24, 30);

            /* ALPHA - Default ASCII font */
            PTXLIB.PTXA_PrintTextEng(lForm, 11, 10, 1, 1, "CORPORATION");
            PTXLIB.PTXA_PrintTextEng(lForm, 12, 10, 0, 0, "STREET 1");
            PTXLIB.PTXA_PrintTextEng(lForm, 13, 10, 0, 0, "IRVINE, CA 92714");
            PTXLIB.PTXA_PrintTextEng(lForm, 4,  8,  0, 0, "FROM:");
            PTXLIB.PTXA_PrintTextEng(lForm, 10, 8,  0, 0, "TO:");
            PTXLIB.PTXA_PrintTextEng(lForm, 16, 8,  0, 0, "S.O.  S05995");
            PTXLIB.PTXA_PrintTextEng(lForm, 21, 8,  0, 0, "S/N: 456789");
            PTXLIB.PTXA_PrintTextEng(lForm, 26, 8,  0, 0, "P/N: 102245");

            /* ASIAN FONT - KAIU.TTF was downloaded separately to printer */
            PTXLIB.PTXA_FontSetup(PTX_Constants.PTXA_FontName, "KAIU.TTF");
            /* SELECT UTF-8 encoding with Asian Font */
            PTXLIB.PTXA_FontSetup(PTX_Constants.PTXA_FontEncoding, "UTF8");
            PTXLIB.PTXA_PrintTextCH(lForm, 6, 10, 1, 1, "一二三");
            PTXLIB.PTXA_PrintTextCH(lForm, 7, 10, 0, 0, "四五六");
            PTXLIB.PTXA_PrintTextCH(lForm, 8, 10, 1, 1, "123456");

            /* BARCODES (5/10 inches high) */
            PTXLIB.PTXA_SetBarcode(PTX_Constants.PTXA_BCD_C39, PTX_Constants.PTXA_BCDOptParam_HEIGHT, "5");
            PTXLIB.PTXA_PrintBarcode(lForm, PTX_Constants.PTXA_BCD_C39, 16, 8, "S05995");
            PTXLIB.PTXA_PrintBarcode(lForm, PTX_Constants.PTXA_BCD_C39, 21, 8, "456789");
            PTXLIB.PTXA_PrintBarcode(lForm, PTX_Constants.PTXA_BCD_C39, 26, 8, "102245");

            /* PRINT THE LABEL */
            PTXLIB.PTXA_PrintForm(lForm);

            /* GET PRINTER STATUS */
            PTXLIB.PTXA_SetupStatus(PTX_Constants.PTXA_SnoopSer);
            Console.WriteLine(Marshal.PtrToStringAnsi(PTXLIB.PTXA_GetStatus()));

            /* CLOSE THE CONNECTION */
            PTXLIB.closeport();

            /* CLOSE THE DLL */
            PTXLIB.PTXA_DLLexit();
        }

        // This function is called by a function of the developer's choosing and can retrieve
        // the status of the printer using the PGL command ~STATUS. In order for this to work
        // properly, the operator panel menu "Application > PGL Setup > Preparser" = "Enable"
        // and "System > Printer Mgmt > Ret. Status Port" = "Automatic" so that the command
        // ~STATUS is sent via USB and results returned via USB.

        private void GetStatus(void) 
        {
	        PTXLIB.PTXA_SetupStatus(PTX_Constants.PTXA_SnoopSer);
	        Console.WriteLine(Marshal.PtrToStringAnsi(PTXLIB.PTXA_GetStatus()));
        }

        // This function is called by a function of the developer's choosing and can send
        // any freeform text to the printer which includes PTX-SETUP commands or even 
        // another emulation such as ZGL. Assumes printer is setup to receive ZGL via the
        // operator panel "Application >> Control >> Active IGP Emul" = "ZGL".

        private void SendData(void) 
        {
	        PTXLIB.sendcommand("^JR\n");
        }
    }
}

