﻿// MIT License
//
// Copyright (c) [2019] [Printronix Auto ID Technology, Inc.]
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

static class PTX_Constants
{
    public const double Pi        = 3.14159;
    public const int SpeedOfLight = 300000; // km per sec.

    /*********** PTXA_SetupStatus () ************/
    /* Input Parameter - mode */
    public const int PTXA_SnoopOff         = 0;   /* Disable snooper */
    public const int PTXA_SnoopSer         = 1;   /* Serial */
    public const int PTXA_SnoopPar         = 2;   /* Parallel */
    public const int PTXA_SnoopEth         = 3;   /* Ethernet */

    /*********** PTXA_JobSetup() **************/
    /* Input Parameter - mode  */
    public const int PTXA_JobModeReset     = 0;   /* There is not Job parameter setting before the form */
    public const int PTXA_JobModeWidth     = 1;   /* Width */
    public const int PTXA_JobModeLength    = 2;   /* Height */
    public const int PTXA_JobModeSpeed     = 3;   /* Speed IPS */
    public const int PTXA_JobModeIntensity = 4;   /* Intensity */
    public const int PTXA_JobModeLabel     = 5;   /* Label Sensor */
    public const int PTXA_JobModeMedia     = 6;   /* Media */
    public const int PTXA_JobModeRotate    = 7;   /* Rotation */

    /* Input Parameter - value for PTXA_JobModeLabel */
    public const int PTXA_JobLabelNoSensor = 0;   /* No sensor */
    public const int PTXA_JobLabelMark     = 1;   /* Mark */
    public const int PTXA_JobLabelGap      = 2;   /* Gap */
    public const int PTXA_JobLabelAdvGap   = 3;   /* Advanced gap */
    public const int PTXA_JobLabelAdvNotch = 4;   /* Advanced notch */

    /* Input Prameter - value for PTXA_JobModeMedia */
    public const int PTXA_JobMediaCon          = 0;   /* Continuous mode */
    public const int PTXA_JobMediaTearoffScrip = 1;   /* Tear-off script */
    public const int PTXA_JobMediaTearoff      = 2;   /* Tear-off mode */
    public const int PTXA_JobMediaPeeroff      = 3;   /* peer-off */
    public const int PTXA_JobMediaCut          = 4;   /* Cut */

    /* Input Parameter - value for PTXA_JobModeRotate */
    public const int PTXA_JobRotatePort    = 0;     /* Portrait */
    public const int PTXA_JobRotateLand    = 90;    /* Landscape */
    public const int PTXA_JobRotateInvPort = 180;   /* Inverted portrait */
    public const int PTXA_JobRotateInvLand = 270;   /* Inverted landscape */

    /********** PTXA_SetBarcode() *************/
    /* Input Parameter - bcdtype (for both PTXA_SetBarcode() and PTXA_PrintBarcode()) */
    public const int PTXA_BCD_C39          = 0;  /* Code39 */
    public const int PTXA_BCD_C128A        = 1;  /* CODE128A */
    public const int PTXA_BCD_C128B        = 2;  /* CODE128B */
    public const int PTXA_BCD_C128C        = 3;  /* CODE128C */
    public const int PTXA_BCD_EAN13        = 4;  /* EAN13 */
    public const int PTXA_BCD_UPCA         = 5;  /* UPCA */
    public const int PTXA_BCD_MAXICODE     = 6;  /* MAXICODE */
    public const int PTXA_BCD_QR           = 7;  /* QR */
    public const int PTXA_BCD_PDF417       = 8;  /* PDF417 */

    /* Input Parameter - mode  */
    public const int PTXA_BCDOptParam_RESET   = 0;   /* No optional parameter attach to barcode*/
    public const int PTXA_BCDOptParam_HEIGHT  = 1;   /* Height */
    public const int PTXA_BCDOptParam_ROTATE  = 2;   /* Rotation */
    public const int PTXA_BCDOptParam_MAGNIFY = 3;   /* Magnify */
    public const int PTXA_BCDOptParam_PDF     = 4;   /* PDF */
    public const int PTXA_BCDOptParam_Ratio   = 5;   /* Ratio */

    /* Input Parameter - value for PTXA_BCDOptParam_ROTATION */
    public const int PTXA_BcdRotatePort       = 0;   /* Portrait */
    public const int PTXA_BcdRotateLand       = 90;  /* Landscape */
    public const int PTXA_BcdRotateInvPort    = 180; /* Inverted portrait */
    public const int PTXA_BcdRotateInvLand    = 270; /* Inverted landscape */

    /* Input Parameter - value for PTXA_BCDOptParam_PDF */
    public const int PTXA_BcdPDFOff = 0;   /* Barcode PDF disabled */
    public const int PTXA_BcdPDFOn  = 1;   /* Barcode PDF enabled */

    /********* PTXA_FormSetup() *************/
    /* Input Parameters - mode  */
    public const int PTXA_FormSetupLength = 1;  /* form length set to CREATE form */
    public const int PTXA_FormSetupCount  = 2;  /* counter of execute the form */

    /************ PTXA_FontSetup() *************/
    public const int PTXA_FontName     = 0;     /* FontName */
    public const int PTXA_FontBold     = 1;     /* FontBold  */
    public const int PTXA_FontSlant    = 2;     /* FontSlant */
    public const int PTXA_FontEncoding = 3;     /* FontEncoding */  

    public const string PTXA_BoldOn     = "ON";     /* Bold on */
    public const string PTXA_BoldOff    = "OFF";    /* Bold off */
    public const string PTXA_SlantRight = "R";      /* Italic slant */
    public const string PTXA_SlantLeft  = "L";      /* Backward slant */
    public const string PTXA_CPAscii    = "ASCII";  /* ASCII encoding */
    public const string PTXA_CPGB       = "GB";     /* GB encoding */
    public const string PTXA_CPBig5     = "BIG5";   /* Big5 for TaiWan encoding */
    public const string PTXA_CPKSC      = "KSC";    /* Korean encoding */
    public const string PTXA_CPSJIS     = "SJIS";   /* Kanji SJIS for Japan encoding */
    public const string PTXA_CPUTF8     = "UTF8";   /* UTF-8 encoding */

    /************ Return value from APIs *************/
    public const int PTXA_OK      = 0;  /* good in return */
    public const int PTXA_INVALID = 1;  /* wrong input parameter – mode/value/lForm/barcodetype  */
}
