// MIT License
//
// Copyright (c) [2019] [Printronix Auto ID Technology, Inc.]
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

/*********** PTXA_SetupStatus () ************/
/* Input Parameter - mode */
#define PTXA_SnoopOff                   0    /* Disable snooper */
#define PTXA_SnoopSer                   1    /* Serial */
#define PTXA_SnoopPar                   2    /* Parallel */
#define PTXA_SnoopEth                   3    /* Ethernet */

/*********** PTXA_JobSetup() **************/
/* Input Parameter - mode  */
#define PTXA_JobModeReset               0    /* There is not Job parameter setting before the form */
#define PTXA_JobModeWidth               1    /* Width */
#define PTXA_JobModeLength              2    /* Height */
#define PTXA_JobModeSpeed               3    /* Speed IPS */
#define PTXA_JobModeIntensity           4    /* Intensity */
#define PTXA_JobModeLabel               5    /* Label Sensor */
#define PTXA_JobModeMedia               6    /* Media */
#define PTXA_JobModeRotate              7    /* Rotation */

/* Input Parameter - value for PTXA_JobModeLabel */
#define PTXA_JobLabelNoSensor           0    /* No sensor */
#define PTXA_JobLabelMark               1    /* Mark */
#define PTXA_JobLabelGap                2    /* Gap */
#define PTXA_JobLabelAdvGap             3    /* Advanced gap */
#define PTXA_JobLabelAdvNotch           4    /* Advanced notch */

/* Input Prameter - value for PTXA_JobModeMedia */
#define PTXA_JobMediaCon                0    /* Continuous mode */
#define PTXA_JobMediaTearoffStrip       1    /* Tear-off script */
#define PTXA_JobMediaTearoff            2    /* Tear-off mode */
#define PTXA_JobMediaPeeloff            3    /* peer-off */
#define PTXA_JobMediaCut                4    /* Cut */

/* Input Parameter - value for PTXA_JobModeRotate */
#define PTXA_JobRotatePort              0    /* Portrait */
#define PTXA_JobRotateLand              90   /* Landscape */
#define PTXA_JobRotateInvPort           180  /* Inverted portrait */
#define PTXA_JobRotateInvLand           270  /* Inverted landscape */

/********** PTXA_SetBarcode() *************/
/* Input Parameter - bcdtype (for both PTXA_SetBarcode() and PTXA_PrintBarcode()) */
#define PTXA_BCD_C39                    0    /* Code39 */
#define PTXA_BCD_C128A                  1    /* CODE128A */
#define PTXA_BCD_C128B                  2    /* CODE128B */
#define PTXA_BCD_C128C                  3    /* CODE128C */
#define PTXA_BCD_EAN13                  4    /* EAN13 */
#define PTXA_BCD_UPCA                   5    /* UPCA */
#define PTXA_BCD_MAXICODE               6    /* MAXICODE */
#define PTXA_BCD_QR                     7    /* QR */
#define PTXA_BCD_PDF417                 8    /* PDF417 */

/* Input Parameter - mode  */
#define PTXA_BCDOptParam_RESET          0    /* No optional parameter attach to barcode*/
#define PTXA_BCDOptParam_HEIGHT         1    /* Height */
#define PTXA_BCDOptParam_ROTATE         2    /* Rotation */	
#define PTXA_BCDOptParam_MAGNIFY        3    /* Magnify */
#define PTXA_BCDOptParam_PDF            4    /* PDF */
#define PTXA_BCDOptParam_Ratio          5    /* Ratio */

/* Input Parameter - value for PTXA_BCDOptParam_ROTATION */
#define PTXA_BcdRotatePort              0    /* Portrait */
#define PTXA_BcdRotateLand              90   /* Landscape */
#define PTXA_BcdRotateInvPort           180  /* Inverted portrait */
#define PTXA_BcdRotateInvLand           270  /* Inverted landscape */

/* Input Parameter - value for PTXA_BCDOptParam_PDF */
#define PTXA_BcdPDFOff                  0    /* Barcode PDF disabled */
#define PTXA_BcdPDFOn                   1    /* Barcode PDF enabled */

/********* PTXA_FormSetup() *************/
/* Input Parameters - mode  */
#define PTXA_FormSetupLength            1    /* form length set to CREATE form */
#define PTXA_FormSetupCount             2    /* counter of execute the form */

/************ PTXA_FontSetup() *************/
#define PTXA_FontName                   0    /* FontName */
#define PTXA_FontBold                   1    /* FontBold  */
#define PTXA_FontSlant                  2    /* FontSlant */
#define PTXA_FontEncoding               3    /* FontEncoding */  

#define PTXA_BoldOn     = "ON";	   /* Bold on */
#define PTXA_BoldOff    = "OFF";    /* Bold off */
#define PTXA_SlantRight = "R";	   /* Italic slant */
#define PTXA_SlantLeft  = "L";	   /* Backward slant */
#define PTXA_CPAscii    = "ASCII";  /* ASCII encoding */
#define PTXA_CPGB       = "GB";	   /* GB encoding */
#define PTXA_CPBig5     = "BIG5";   /* Big5 for TaiWan encoding */
#define PTXA_CPKSC      = "KSC";    /* Korean encoding */
#define PTXA_CPSJIS     = "SJIS";   /* Kanji SJIS for Japan encoding */
#define PTXA_CPUTF8     = "UTF8";   /* UTF-8 encoding */
 
/************ Return value from APIs *************/
#define PTXA_OK                         0    /* good in return */
#define PTXA_INVALID                    1    /* wrong input parameter V mode/value/lForm/barcodetype  */
