'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _crypto() {
  const data = require('crypto');

  _crypto = function () {
    return data;
  };

  return data;
}

function _fs() {
  const data = require('fs');

  _fs = function () {
    return data;
  };

  return data;
}

function _path() {
  const data = require('path');

  _path = function () {
    return data;
  };

  return data;
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
// eslint-disable-next-line no-restricted-imports
function getGlobalCacheKey(files, values) {
  return [
    process.env.NODE_ENV,
    process.env.BABEL_ENV,
    ...values,
    ...files.map(file => (0, _fs().readFileSync)(file))
  ]
    .reduce(
      (hash, chunk) => hash.update('\0', 'utf8').update(chunk || ''),
      (0, _crypto().createHash)('md5')
    )
    .digest('hex');
}

function getCacheKeyFunction(globalCacheKey) {
  return (src, file, _configString, options) => {
    const {config, instrument} = options;
    return (0, _crypto().createHash)('md5')
      .update(globalCacheKey)
      .update('\0', 'utf8')
      .update(src)
      .update('\0', 'utf8')
      .update(config.rootDir ? (0, _path().relative)(config.rootDir, file) : '')
      .update('\0', 'utf8')
      .update(instrument ? 'instrument' : '')
      .digest('hex');
  };
}

var _default = (files = [], values = []) =>
  getCacheKeyFunction(getGlobalCacheKey(files, values));

exports.default = _default;
