/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";

function _slicedToArray(arr, i) {
  return (
    _arrayWithHoles(arr) ||
    _iterableToArrayLimit(arr, i) ||
    _unsupportedIterableToArray(arr, i) ||
    _nonIterableRest()
  );
}

function _nonIterableRest() {
  throw new TypeError(
    "Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
  );
}

function _iterableToArrayLimit(arr, i) {
  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr)))
    return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (
      var _i = arr[Symbol.iterator](), _s;
      !(_n = (_s = _i.next()).done);
      _n = true
    ) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _toConsumableArray(arr) {
  return (
    _arrayWithoutHoles(arr) ||
    _iterableToArray(arr) ||
    _unsupportedIterableToArray(arr) ||
    _nonIterableSpread()
  );
}

function _nonIterableSpread() {
  throw new TypeError(
    "Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
  );
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o, minLen);
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter))
    return Array.from(iter);
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

const _require = require("metro-hermes-compiler"),
  getFileLength = _require.getFileLength; // The magic number is used as a header for bytecode.
// It represents a Metro tunnel in binary.
//
// 11111111
// 11100111
// 11000011
// 11000011

const MAGIC_NUMBER = 0xffe7c3c3;

function getFileHeader(moduleCount) {
  const buffer = Buffer.alloc(8);
  buffer.writeUInt32LE(MAGIC_NUMBER, 0);
  buffer.writeUInt32LE(moduleCount, 4);
  return buffer;
}

function addModuleHeader(buffer) {
  const fileLength = getFileLength(buffer, 0);
  const header = Buffer.alloc(4);
  header.writeUInt32LE(fileLength, 0);
  return [header, buffer];
}
/**
 * A bytecode bundle has the following format:
 *
 * 4 bytes MAGIC_NUMBER
 * 4 bytes Module count
 * 4 bytes Module length N + N bytes
 * ...
 *
 */

function bundleToBytecode(bundle) {
  const buffers = [];

  if (bundle.pre.length) {
    buffers.push.apply(buffers, _toConsumableArray(bundle.pre));
  }

  const modules = [];
  const sortedModules = bundle.modules
    .slice() // In a JS bundle, the order of modules needs to be deterministic for source
    // maps to work. This constraint is not necessary for bytecode bundles but
    // is kept for consistency.
    .sort((a, b) => a[0] - b[0]);

  for (const _ref of sortedModules) {
    var _ref2 = _slicedToArray(_ref, 2);

    const id = _ref2[0];
    const bytecodeBundle = _ref2[1];
    buffers.push.apply(buffers, _toConsumableArray(bytecodeBundle)); // Use the size of the last item in `bytecodeBundle` which is always
    // the actual module without headers.

    modules.push([id, bytecodeBundle[bytecodeBundle.length - 1].length]);
  }

  if (bundle.post.length) {
    buffers.push.apply(buffers, _toConsumableArray(bundle.post));
  }

  return {
    bytecode: Buffer.concat(
      [getFileHeader(buffers.length)].concat(
        _toConsumableArray(buffers.flatMap(addModuleHeader))
      )
    ),
    metadata: {
      pre: bundle.pre ? bundle.pre.length : 0,
      post: bundle.post.length,
      modules
    }
  };
}

module.exports = bundleToBytecode;
module.exports.MAGIC_NUMBER = MAGIC_NUMBER;
