/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
'use strict';

// File path -> contents
const template = `
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * ${'@'}generated by codegen project: GenerateComponentDescriptorH.js
 */

#pragma once

#include <react/renderer/components/::_LIBRARY_::/ShadowNodes.h>
#include <react/renderer/core/ConcreteComponentDescriptor.h>

namespace facebook {
namespace react {

::_COMPONENT_DESCRIPTORS_::

} // namespace react
} // namespace facebook
`;
const componentTemplate = `
using ::_CLASSNAME_::ComponentDescriptor = ConcreteComponentDescriptor<::_CLASSNAME_::ShadowNode>;
`.trim();
module.exports = {
  generate(libraryName, schema, moduleSpecName, packageName) {
    const fileName = 'ComponentDescriptors.h';
    const componentDescriptors = Object.keys(schema.modules)
      .map(moduleName => {
        const module = schema.modules[moduleName];

        if (module.type !== 'Component') {
          return;
        }

        const components = module.components; // No components in this module

        if (components == null) {
          return null;
        }

        return Object.keys(components)
          .map(componentName => {
            if (components[componentName].interfaceOnly === true) {
              return;
            }

            return componentTemplate.replace(/::_CLASSNAME_::/g, componentName);
          })
          .join('\n');
      })
      .filter(Boolean)
      .join('\n');
    const replacedTemplate = template
      .replace(/::_COMPONENT_DESCRIPTORS_::/g, componentDescriptors)
      .replace('::_LIBRARY_::', libraryName);
    return new Map([[fileName, replacedTemplate]]);
  },
};
