import React from 'react';
import {
  SafeAreaView,
  StyleSheet,
  Button,
} from 'react-native';

import NativeSendModule from './specs/NativeSendModule';

const EMPTY = '<empty>';

function App(): React.JSX.Element {

  function sendTestFile() {
    NativeSendModule.sendTestFile()
  }

  return (
    <SafeAreaView style={styles.container}>
      <Button title="Send Test file" onPress={sendTestFile}/>
    </SafeAreaView>
  );
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        justifyContent: 'center', 
        alignItems: 'center', 
    },
});

export default App;