/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorKeys = exports.ScopeType = exports.DefinitionType = void 0;
exports.parse = parse;
exports.parseForESLint = parseForESLint;

var HermesParser = _interopRequireWildcard(require("hermes-parser"));

var _scopeManager = require("./scope-manager");

exports.ScopeType = _scopeManager.ScopeType;
exports.DefinitionType = _scopeManager.DefinitionType;

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function parse(code, options) {
  var _options$sourceType, _options$enableExperi;

  const parserOptions = {
    allowReturnOutsideFunction: true,
    flow: 'all',
    sourceType: (_options$sourceType = options == null ? void 0 : options.sourceType) != null ? _options$sourceType : 'module',
    tokens: true,
    enableExperimentalComponentSyntax: (_options$enableExperi = options == null ? void 0 : options.enableExperimentalComponentSyntax) != null ? _options$enableExperi : true
  };

  try {
    const ast = HermesParser.parse(code, parserOptions);
    return ast;
  } catch (e) {
    // Format error location for ESLint
    if (e instanceof SyntaxError) {
      // $FlowFixMe[prop-missing]
      e.lineNumber = e.loc.line; // $FlowFixMe[prop-missing]

      e.column = e.loc.column;
    }

    throw e;
  }
}

const VisitorKeys = HermesParser.FlowVisitorKeys;
exports.VisitorKeys = VisitorKeys;

function parseForESLint(code, options) {
  const ast = parse(code, options); // set the parent pointers

  HermesParser.SimpleTraverser.traverse(ast, {
    enter(node, parent) {
      // $FlowExpectedError[cannot-write]
      node.parent = parent;
    },

    leave() {}

  });
  const scopeManager = (0, _scopeManager.analyze)(ast, options);
  return {
    ast,
    scopeManager,
    visitorKeys: VisitorKeys
  };
}