/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIdGenerator = createIdGenerator;
exports.resetIds = resetIds;
const ID_CACHE = new Map();
let NEXT_KEY = 0;

function createIdGenerator() {
  const key = NEXT_KEY += 1;
  ID_CACHE.set(key, 0);
  return () => {
    var _ID_CACHE$get;

    const current = (_ID_CACHE$get = ID_CACHE.get(key)) != null ? _ID_CACHE$get : 0;
    const next = current + 1;
    ID_CACHE.set(key, next);
    return next;
  };
}

function resetIds() {
  ID_CACHE.clear();
}