/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassNameDefinition = void 0;

var _DefinitionType = require("./DefinitionType");

var _DefinitionBase = require("./DefinitionBase");

class ClassNameDefinition extends _DefinitionBase.DefinitionBase {
  constructor(name, node) {
    super(_DefinitionType.DefinitionType.ClassName, name, node, null);
    this.isTypeDefinition = true;
    this.isVariableDefinition = true;
  }

}

exports.ClassNameDefinition = ClassNameDefinition;