/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentNameDefinition = void 0;

var _DefinitionType = require("./DefinitionType");

var _DefinitionBase = require("./DefinitionBase");

class ComponentNameDefinition extends _DefinitionBase.DefinitionBase {
  constructor(name, node) {
    super(_DefinitionType.DefinitionType.ComponentName, name, node, null);
    this.isTypeDefinition = false;
    this.isVariableDefinition = true;
  }

}

exports.ComponentNameDefinition = ComponentNameDefinition;