/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefinitionBase = void 0;

var _ID = require("../ID");

const generator = (0, _ID.createIdGenerator)();
/* abstract */

class DefinitionBase {
  /**
   * A unique ID for this instance - primarily used to help debugging and testing
   */

  /**
   * The type of the definition
   * @public
   */

  /**
   * The `Identifier` node of this definition
   * @public
   */

  /**
   * The enclosing node of the name.
   * @public
   */

  /**
   * the enclosing statement node of the identifier.
   * @public
   */
  constructor(type, name, node, parent) {
    this.$id = generator();
    this.type = void 0;
    this.name = void 0;
    this.node = void 0;
    this.parent = void 0;
    this.isTypeDefinition = void 0;
    this.isVariableDefinition = void 0;
    this.type = type;
    this.name = name;
    this.node = node;
    this.parent = parent;
  }
  /**
   * `true` if the variable is valid in a type context, false otherwise
   * @public
   */


}

exports.DefinitionBase = DefinitionBase;