/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportBindingDefinition = void 0;

var _DefinitionType = require("./DefinitionType");

var _DefinitionBase = require("./DefinitionBase");

class ImportBindingDefinition extends _DefinitionBase.DefinitionBase {
  constructor(name, node, decl) {
    super(_DefinitionType.DefinitionType.ImportBinding, name, node, decl);
    this.isTypeDefinition = true;
    this.isVariableDefinition = void 0;

    switch (node.type) {
      case 'ImportSpecifier':
        if (node.importKind === 'type' || node.importKind === 'typeof' || decl.importKind === 'type' || decl.importKind === 'typeof') {
          this.isVariableDefinition = false;
        } else {
          this.isVariableDefinition = true;
        }

        break;

      case 'ImportDefaultSpecifier':
        if (decl.importKind === 'type' || decl.importKind === 'typeof') {
          this.isVariableDefinition = false;
        } else {
          this.isVariableDefinition = true;
        }

        break;

      case 'ImportNamespaceSpecifier':
        this.isVariableDefinition = true;
        break;
    }
  } // all imports are treated as "type" definitions regardless of whether or
  // not they have a "type" kind. You can import classes and enums as values
  // and use them in type locations. Additionally namespace imports can be
  // used in a type location (eg React.MixedElement).


}

exports.ImportBindingDefinition = ImportBindingDefinition;