/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParameterDefinition = void 0;

var _DefinitionType = require("./DefinitionType");

var _DefinitionBase = require("./DefinitionBase");

class ParameterDefinition extends _DefinitionBase.DefinitionBase {
  /**
   * Whether the parameter definition is a part of a rest parameter.
   */
  constructor(name, node, rest) {
    super(_DefinitionType.DefinitionType.Parameter, name, node, null);
    this.rest = void 0;
    this.isTypeDefinition = false;
    this.isVariableDefinition = true;
    this.rest = rest;
  }

}

exports.ParameterDefinition = ParameterDefinition;