/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeParameterDefinition = void 0;

var _DefinitionType = require("./DefinitionType");

var _DefinitionBase = require("./DefinitionBase");

class TypeParameterDefinition extends _DefinitionBase.DefinitionBase {
  constructor(node) {
    // The ScopeManager API expects an Identifier node that can be referenced
    // for each definition. TypeParameter nodes do not actually contain an
    // Identifier node, so we create a fake one with the correct name,
    // location, and parent so that it is still usable with the ScopeManager.
    const id = {
      type: 'Identifier',
      loc: node.loc,
      name: node.name,
      parent: node,
      range: node.range,
      optional: false,
      typeAnnotation: null
    };
    super(_DefinitionType.DefinitionType.TypeParameter, id, node, null);
    this.isTypeDefinition = true;
    this.isVariableDefinition = false;
  }

}

exports.TypeParameterDefinition = TypeParameterDefinition;