/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  analyze: true,
  Reference: true,
  ScopeManager: true
};
exports.analyze = exports.ScopeManager = exports.Reference = void 0;

var _analyze = require("./analyze");

exports.analyze = _analyze.analyze;

var _definition = require("./definition");

Object.keys(_definition).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _definition[key]) return;
  exports[key] = _definition[key];
});

var _Reference = require("./referencer/Reference");

exports.Reference = _Reference.Reference;

var _scope = require("./scope");

Object.keys(_scope).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _scope[key]) return;
  exports[key] = _scope[key];
});

var _ScopeManager = require("./ScopeManager");

exports.ScopeManager = _ScopeManager.ScopeManager;

var _variable = require("./variable");

Object.keys(_variable).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _variable[key]) return;
  exports[key] = _variable[key];
});