/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportVisitor = void 0;

var _Visitor = require("./Visitor");

class ExportVisitor extends _Visitor.Visitor {
  constructor(node, referencer) {
    super(referencer);
    this._referencer = void 0;
    this._exportNode = void 0;
    this._exportNode = node;
    this._referencer = referencer;
  }

  static visit(referencer, node) {
    const exportReferencer = new ExportVisitor(node, referencer);
    exportReferencer.visit(node);
  }

  Identifier(node) {
    if (this._exportNode.exportKind === 'type') {
      // export type { T };
      // type exports can only reference types
      this._referencer.currentScope().referenceType(node);
    } else {
      this._referencer.currentScope().referenceDualValueType(node);
    }
  }

  ExportDefaultDeclaration(node) {
    if (node.declaration.type === 'Identifier') {
      // export default A;
      // this could be a type or a variable
      this.visit(node.declaration);
    } else {// export const a = 1;
      // export something();
      // etc
      // these not included in the scope of this visitor as they are all guaranteed to be values or declare variables
    }
  }

  ExportNamedDeclaration(node) {
    if (node.source) {
      // export ... from 'foo';
      // these are external identifiers so there shouldn't be references or defs
      return;
    }

    if (!node.declaration) {
      // export { x };
      this.visitChildren(node);
    } else {// export const x = 1;
      // this is not included in the scope of this visitor as it creates a variable
    }
  }

  ExportSpecifier(node) {
    this.visit(node.local);
  }

}

exports.ExportVisitor = ExportVisitor;