/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportVisitor = void 0;

var _definition = require("../definition");

var _Visitor = require("./Visitor");

class ImportVisitor extends _Visitor.Visitor {
  constructor(declaration, referencer) {
    super(referencer);
    this._declaration = void 0;
    this._referencer = void 0;
    this._declaration = declaration;
    this._referencer = referencer;
  }

  static visit(referencer, declaration) {
    const importReferencer = new ImportVisitor(declaration, referencer);
    importReferencer.visit(declaration);
  }

  visitImport(id, specifier) {
    this._referencer.currentScope().defineIdentifier(id, new _definition.ImportBindingDefinition(id, specifier, this._declaration));
  }

  ImportNamespaceSpecifier(node) {
    const local = node.local;
    this.visitImport(local, node);
  }

  ImportDefaultSpecifier(node) {
    const local = node.local;
    this.visitImport(local, node);
  }

  ImportSpecifier(node) {
    const local = node.local;
    this.visitImport(local, node);
  }

}

exports.ImportVisitor = ImportVisitor;