/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternVisitor = void 0;

var _VisitorBase = require("./VisitorBase");

// $FlowFixMe[deprecated-type]
function isPattern(node) {
  return node.type === 'Identifier' || node.type === 'ObjectPattern' || node.type === 'ArrayPattern' || node.type === 'SpreadElement' || node.type === 'RestElement' || node.type === 'AssignmentPattern';
}

class PatternVisitor extends _VisitorBase.VisitorBase {
  constructor(options, rootPattern, identifierCallback, typeAnnotationCallback) {
    super(options);
    this._rootPattern = void 0;
    this._identifierCallback = void 0;
    this._typeAnnotationCallback = void 0;
    this._assignments = [];
    this.rightHandNodes = [];
    this._restElements = [];
    this._rootPattern = rootPattern;
    this._identifierCallback = identifierCallback;
    this._typeAnnotationCallback = typeAnnotationCallback;
  } //
  // Visitors
  //


  ArrayExpression(node) {
    this.visitArray(node.elements);
  }

  ArrayPattern(pattern) {
    for (const element of pattern.elements) {
      this.visit(element);
    }

    if (pattern.typeAnnotation) {
      this._typeAnnotationCallback(pattern.typeAnnotation, pattern);
    }
  }

  AssignmentExpression(node) {
    this._assignments.push(node);

    this.visit(node.left);
    this.rightHandNodes.push(node.right);

    this._assignments.pop();
  }

  AssignmentPattern(pattern) {
    this._assignments.push(pattern);

    this.visit(pattern.left);
    this.rightHandNodes.push(pattern.right);

    this._assignments.pop();
  }

  CallExpression(node) {
    // arguments are right hand nodes.
    node.arguments.forEach(a => {
      this.rightHandNodes.push(a);
    });
    this.visit(node.callee);
  }

  Identifier(pattern) {
    var _this$_restElements;

    const lastRestElement = (_this$_restElements = this._restElements[this._restElements.length - 1]) != null ? _this$_restElements : null;

    this._identifierCallback(pattern, {
      topLevel: pattern === this._rootPattern,
      rest: lastRestElement != null && lastRestElement.argument === pattern,
      assignments: this._assignments
    });

    if (pattern.typeAnnotation) {
      this._typeAnnotationCallback(pattern.typeAnnotation, pattern);
    }
  }

  MemberExpression(node) {
    // Computed property's key is a right hand node.
    if (node.computed === true) {
      this.rightHandNodes.push(node.property);
    } // the object is only read, write to its property.


    this.rightHandNodes.push(node.object);
  }

  ObjectPattern(pattern) {
    for (const property of pattern.properties) {
      this.visit(property);
    }

    if (pattern.typeAnnotation) {
      this._typeAnnotationCallback(pattern.typeAnnotation, pattern);
    }
  }

  Property(property) {
    // Computed property's key is a right hand node.
    if (property.computed) {
      this.rightHandNodes.push(property.key);
    } // If it's shorthand, its key is same as its value.
    // If it's shorthand and has its default value, its key is same as its value.left (the value is AssignmentPattern).
    // If it's not shorthand, the name of new variable is its value's.


    this.visit(property.value);
  }

  RestElement(pattern) {
    this._restElements.push(pattern);

    this.visit(pattern.argument);

    this._restElements.pop();
  }

  SpreadElement(node) {
    this.visit(node.argument);
  }

  TypeAnnotation(_node) {// we don't want to visit types implicitly
  }

}

exports.PatternVisitor = PatternVisitor;
PatternVisitor.isPattern = isPattern;