/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint unsafe-getters-setters:off
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceTypeFlag = exports.ReferenceFlag = exports.Reference = void 0;

var _ID = require("../ID");

const ReferenceFlag = {
  Read: 0x1,
  Write: 0x2,
  ReadWrite: 0x3
};
exports.ReferenceFlag = ReferenceFlag;
const generator = (0, _ID.createIdGenerator)();
const ReferenceTypeFlag = {
  Value: 0x1,
  Type: 0x2,
  ValueAndType: 0x3
};
exports.ReferenceTypeFlag = ReferenceTypeFlag;

/**
 * A Reference represents a single occurrence of an identifier in code.
 */
class Reference {
  /**
   * A unique ID for this instance - primarily used to help debugging and testing
   */

  /**
   * The read-write mode of the reference.
   */

  /**
   * Reference to the enclosing Scope.
   * @public
   */

  /**
   * Identifier syntax node.
   * @public
   */

  /**
   * `true` if this writing reference is a variable initializer or a default value.
   * @public
   */

  /**
   * The {@link Variable} object that this reference refers to. If such variable was not defined, this is `null`.
   * @public
   */

  /**
   * If reference is writeable, this is the node being written to it.
   * @public
   */

  /**
   * In some cases, a reference may be a type, value or both a type and value reference.
   */

  /**
   * True if this reference can reference types
   * @public
   */
  get isTypeReference() {
    return (this._referenceType & ReferenceTypeFlag.Type) !== 0;
  }
  /**
   * True if this reference can reference values
   * @public
   */


  get isValueReference() {
    return (this._referenceType & ReferenceTypeFlag.Value) !== 0;
  }

  constructor(identifier, scope, flag, writeExpr, maybeImplicitGlobal, init, referenceType = ReferenceTypeFlag.Value) {
    this.$id = generator();
    this._flag = void 0;
    this.from = void 0;
    this.identifier = void 0;
    this.init = void 0;
    this.resolved = void 0;
    this.writeExpr = void 0;
    this.maybeImplicitGlobal = void 0;
    this._referenceType = void 0;
    this.identifier = identifier;
    this.from = scope;
    this.resolved = null;
    this._flag = flag;

    if (this.isWrite()) {
      this.writeExpr = writeExpr;
      this.init = init;
    }

    this.maybeImplicitGlobal = maybeImplicitGlobal;
    this._referenceType = referenceType;
  }
  /**
   * Whether the reference is writeable.
   * @public
   */


  isWrite() {
    return !!(this._flag & ReferenceFlag.Write);
  }
  /**
   * Whether the reference is readable.
   * @public
   */


  isRead() {
    return !!(this._flag & ReferenceFlag.Read);
  }
  /**
   * Whether the reference is read-only.
   * @public
   */


  isReadOnly() {
    return this._flag === ReferenceFlag.Read;
  }
  /**
   * Whether the reference is write-only.
   * @public
   */


  isWriteOnly() {
    return this._flag === ReferenceFlag.Write;
  }
  /**
   * Whether the reference is read-write.
   * @public
   */


  isReadWrite() {
    return this._flag === ReferenceFlag.ReadWrite;
  }

}

exports.Reference = Reference;