/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Visitor = void 0;

var _VisitorBase = require("./VisitorBase");

exports.VisitorBase = _VisitorBase.VisitorBase;

var _PatternVisitor = require("./PatternVisitor");

class Visitor extends _VisitorBase.VisitorBase {
  constructor(optionsOrVisitor) {
    super(optionsOrVisitor instanceof Visitor ? optionsOrVisitor._options : optionsOrVisitor);
    this._options = void 0;
    this._options = optionsOrVisitor instanceof Visitor ? optionsOrVisitor._options : optionsOrVisitor;
  }

  visitPattern(node, identifierCallback, typeAnnotationCallback, options = {
    processRightHandNodes: false
  }) {
    // Call the callback at left hand identifier nodes, and Collect right hand nodes.
    const visitor = new _PatternVisitor.PatternVisitor(this._options, node, identifierCallback, typeAnnotationCallback);
    visitor.visit(node); // Process the right hand nodes recursively.

    if (options.processRightHandNodes === true) {
      this.visitArray(visitor.rightHandNodes);
    }
  }

}

exports.Visitor = Visitor;