/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBase = void 0;

var _hermesParser = require("hermes-parser");

// $FlowFixMe[deprecated-type]
function isNode(node) {
  return typeof node === 'object' && node != null && typeof node.type === 'string';
}

/* abstract */
class VisitorBase {
  constructor(options) {
    var _options$childVisitor;

    this._childVisitorKeys = void 0;

    this.visitArray = arr => {
      if (arr == null) {
        return;
      }

      for (const child of arr) {
        this.visit(child);
      }
    };

    this._childVisitorKeys = (_options$childVisitor = options.childVisitorKeys) != null ? _options$childVisitor : _hermesParser.FlowVisitorKeys;
  }
  /**
   * Default method for visiting children.
   * @param node the node whose children should be visited
   * @param exclude a list of keys to not visit
   */


  visitChildren(node, excludeArr = []) {
    var _this$_childVisitorKe;

    if (node == null || node.type == null) {
      return;
    }

    if (node.type === 'VariableDeclaration') {
      console.trace('wtf');
    }

    const exclude = new Set(excludeArr.concat(['parent']));
    const children = (_this$_childVisitorKe = this._childVisitorKeys[node.type]) != null ? _this$_childVisitorKe : Object.keys(node);

    for (const key of children) {
      if (exclude.has(key)) {
        continue;
      } // $FlowExpectedError[prop-missing]


      const child = node[key];

      if (child == null) {
        continue;
      }

      if (Array.isArray(child)) {
        for (const subChild of child) {
          if (isNode(subChild)) {
            this.visit(subChild);
          }
        }
      } else if (isNode(child)) {
        this.visit(child);
      }
    }
  }
  /**
   * Dispatching node.
   */


  visit(node) {
    if (node == null || node.type == null) {
      return;
    } // $FlowExpectedError[prop-missing] - subclasses declare the relevant methods


    const visitor = this[node.type];

    if (visitor) {
      visitor.call(this, node); // assume the visitor function handled the children appropriately

      return;
    }

    this.visitChildren(node);
  }

}

exports.VisitorBase = VisitorBase;