/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

class ComponentScope extends _ScopeBase.ScopeBase {
  constructor(scopeManager, upperScope, block) {
    super(scopeManager, _ScopeType.ScopeType.Component, upperScope, block, false);
  } // References in default parameters isn't resolved to variables which are in their body.
  //     const x = 1
  //     component Foo(a = x) { // This `x` is resolved to the `x` in the outer scope.
  //         const x = 2
  //         console.log(a)
  //     }


  __isValidResolution(ref, variable) {
    var _this$block$body$rang;

    const bodyStart = (_this$block$body$rang = this.block.body.range[0]) != null ? _this$block$body$rang : -1; // It's invalid resolution in the following case:

    return !(variable.scope === this && ref.identifier.range[0] < bodyStart && // the reference is in the parameter part.
    variable.defs.every(d => d.name.range[0] >= bodyStart) // the variable is in the body.
    );
  }

}

exports.ComponentScope = ComponentScope;