/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionExpressionNameScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

var _definition = require("../definition");

class FunctionExpressionNameScope extends _ScopeBase.ScopeBase {
  constructor(scopeManager, upperScope, block) {
    super(scopeManager, _ScopeType.ScopeType.FunctionExpressionName, upperScope, block, false);
    this.functionExpressionScope = true;

    if (block.id) {
      this.defineIdentifier(block.id, new _definition.FunctionNameDefinition(block.id, block));
    }
  }

}

exports.FunctionExpressionNameScope = FunctionExpressionNameScope;