/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

class FunctionScope extends _ScopeBase.ScopeBase {
  constructor(scopeManager, upperScope, block, isMethodDefinition) {
    super(scopeManager, _ScopeType.ScopeType.Function, upperScope, block, isMethodDefinition); // section 9.2.13, FunctionDeclarationInstantiation.
    // NOTE Arrow functions never have an arguments objects.

    if (this.block.type !== 'ArrowFunctionExpression') {
      this.__defineVariable('arguments', this.set, this.variables, null, null);
    }
  } // References in default parameters isn't resolved to variables which are in their function body.
  //     const x = 1
  //     function f(a = x) { // This `x` is resolved to the `x` in the outer scope.
  //         const x = 2
  //         console.log(a)
  //     }


  __isValidResolution(ref, variable) {
    var _this$block$body$rang, _this$block$body;

    // If `options.gloablReturn` is true, `this.block` becomes a Program node.
    if (this.block.type === 'Program') {
      return true;
    }

    const bodyStart = (_this$block$body$rang = (_this$block$body = this.block.body) == null ? void 0 : _this$block$body.range[0]) != null ? _this$block$body$rang : -1; // It's invalid resolution in the following case:

    return !(variable.scope === this && ref.identifier.range[0] < bodyStart && // the reference is in the parameter part.
    variable.defs.every(d => d.name.range[0] >= bodyStart) // the variable is in the body.
    );
  }

}

exports.FunctionScope = FunctionScope;