/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

var _ImplicitGlobalVariableDefinition = require("../definition/ImplicitGlobalVariableDefinition");

class GlobalScope extends _ScopeBase.ScopeBase {
  // note this is accessed in used in the legacy eslint-scope tests, so it can't be true private
  constructor(scopeManager, block) {
    super(scopeManager, _ScopeType.ScopeType.Global, null, block, false);
    this.__implicit = void 0;
    this.__implicit = {
      set: new Map(),
      variables: [],
      referencesLeftToResolve: []
    };
  }

  close(scopeManager) {
    if (this.__referencesLeftToResolve == null) {
      throw new Error('__referencesLeftToResolve was unexpectedly null.');
    }

    for (const ref of this.__referencesLeftToResolve) {
      const info = ref.maybeImplicitGlobal;

      if (info && !this.set.has(ref.identifier.name)) {
        // create an implicit global variable from assignment expression
        const node = info.pattern;

        if (node && node.type === 'Identifier') {
          this.__defineVariable(node.name, this.__implicit.set, this.__implicit.variables, node, new _ImplicitGlobalVariableDefinition.ImplicitGlobalVariableDefinition(info.pattern, info.node));
        }
      }
    } // $FlowFixMe[incompatible-type] We know this value is an array at this point.


    this.__implicit.referencesLeftToResolve = this.__referencesLeftToResolve;
    return super.close(scopeManager);
  }

}

exports.GlobalScope = GlobalScope;