/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModuleScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

var _DefinitionType = require("../definition/DefinitionType");

class ModuleScope extends _ScopeBase.ScopeBase {
  constructor(scopeManager, upperScope, block) {
    super(scopeManager, _ScopeType.ScopeType.Module, upperScope, block, false);
  }

  close(scopeManager) {
    const result = super.close(scopeManager); // handle this case:

    /*
    declare function foo(): void;
    declare function foo(arg: string): string;
    export function foo(arg?: string) {
      return arg;
    }
    */

    for (const variable of this.variables) {
      if (variable.defs.length <= 1) {
        continue;
      }

      for (const def of variable.defs) {
        if (def.type !== _DefinitionType.DefinitionType.FunctionName) {
          break;
        }

        if (def.node.type === 'FunctionDeclaration' && (def.node.parent.type === 'ExportNamedDeclaration' || def.node.parent.type === 'ExportDefaultDeclaration')) {
          variable.eslintUsed = true;
          break;
        }
      }
    }

    return result;
  }

}

exports.ModuleScope = ModuleScope;