/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithScope = void 0;

var _ScopeBase = require("./ScopeBase");

var _ScopeType = require("./ScopeType");

class WithScope extends _ScopeBase.ScopeBase {
  constructor(scopeManager, upperScope, block) {
    super(scopeManager, _ScopeType.ScopeType.With, upperScope, block, false);
  }

  close(scopeManager) {
    if (this.shouldStaticallyClose()) {
      return super.close(scopeManager);
    }

    if (this.__referencesLeftToResolve == null) {
      throw new Error('__referencesLeftToResolve was unexpectedly null.');
    }

    for (let i = 0; i < this.__referencesLeftToResolve.length; ++i) {
      const ref = this.__referencesLeftToResolve[i];

      this.__delegateToUpperScope(ref);
    }

    this.__referencesLeftToResolve = null;
    return this.upper;
  }

}

exports.WithScope = WithScope;