/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESLintScopeVariable = void 0;

var _VariableBase = require("./VariableBase");

/**
 * ESLint defines global variables using the eslint-scope Variable class
 * This is declared here for consumers to use
 */
class ESLintScopeVariable extends _VariableBase.VariableBase {
  constructor(...args) {
    super(...args);
    this.writeable = void 0;
    this.eslintExplicitGlobal = void 0;
    this.eslintImplicitGlobalSetting = void 0;
    this.eslintExplicitGlobalComments = void 0;
  }

}

exports.ESLintScopeVariable = ESLintScopeVariable;