/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint unsafe-getters-setters:off
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Variable = void 0;

var _VariableBase = require("./VariableBase");

/**
 * A Variable represents a locally scoped identifier. These include arguments to functions.
 */
class Variable extends _VariableBase.VariableBase {
  /**
   * `true` if the variable is valid in a type context, false otherwise
   * @public
   */
  get isTypeVariable() {
    if (this.defs.length === 0) {
      // we don't statically know whether this is a type or a value
      return true;
    }

    return this.defs.some(def => def.isTypeDefinition);
  }
  /**
   * `true` if the variable is valid in a value context, false otherwise
   * @public
   */


  get isValueVariable() {
    if (this.defs.length === 0) {
      // we don't statically know whether this is a type or a value
      return true;
    }

    return this.defs.some(def => def.isVariableDefinition);
  }

}

exports.Variable = Variable;