/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariableBase = void 0;

var _ID = require("../ID");

const generator = (0, _ID.createIdGenerator)();

class VariableBase {
  /**
   * A unique ID for this instance - primarily used to help debugging and testing
   */

  /**
   * The array of the definitions of this variable.
   * @public
   */

  /**
   * True if the variable is considered used for the purposes of `no-unused-vars`, false otherwise.
   * @public
   */

  /**
   * The array of `Identifier` nodes which define this variable.
   * If this variable is redeclared, this array includes two or more nodes.
   * @public
   */

  /**
   * The variable name, as given in the source code.
   * @public
   */

  /**
   * List of {@link Reference} of this variable (excluding parameter entries)  in its defining scope and all nested scopes.
   * For defining occurrences only see {@link Variable#defs}.
   * @public
   */

  /**
   * Reference to the enclosing Scope.
   * @public
   */
  constructor(name, scope) {
    this.$id = generator();
    this.defs = [];
    this.eslintUsed = false;
    this.identifiers = [];
    this.name = void 0;
    this.references = [];
    this.scope = void 0;
    this.name = name;
    this.scope = scope;
  }

}

exports.VariableBase = VariableBase;