//
//  com.sdk.PrintService.m
//  Test
//
//  Created by Muta Huang on 2020/9/23.
//

#import <Foundation/Foundation.h>
#include "com.sdk.PrintService.h"
#include "TSCSDK.h"

@implementation com.sdk.PrintService

- (void) Print:(CDVInvokedUrlCommand *)command
{
    NSString* callBackID = command.callbackId;
    
    TSCSDK *lib = [TSCSDK new];
    //[lib openportMFI:@"com.issc.datapath"];
    [lib openport:@"10.0.10.202"];
    
    //NSData *status = [lib printer_status];
    //0x00:Normal, 0x01:Head opened, 0x10:Pause
    
    [lib sendCommand:@"DIRECION 1\r\n"];
    //[lib setup:@"100" height:@"120" speed:@"4" density:@"10" sensor:@"0" vertical:@"2" offset:@"0"];
    [lib sendCommand:@"SIZE 100 mm, 120 mm\r\n"];
    [lib sendCommand:@"SPEED 4\r\n"];
    [lib sendCommand:@"DENSITY 10\r\n"];
    [lib sendCommand:@"GAP 0 mm, 0 mm\r\n"];
    //[lib sendCommand:@"BLINE 2 mm, 0 mm\r\n"];
     
    [lib clearBuffer];
    
    //Using downloaded font to print text
    [lib sendCommand:@"CODEPAGE UTF-8\r\n"];
    [lib sendCommand_utf8:@"TEXT 30,30,\"ARIALUNI.TTF\",0,8,8,\"中文Englishにほンゴ한국어\"\r\n"];
    //[lib sendCommand:@"TEXT 30,30,\"2\",0,2,2,\"1234567\"\r\n"];
    [lib printerfont:@"30" y:@"100" fontName:@"2" rotation:@"0" magnificationRateX:@"2" magnificationRateY:@"2" content:@"Printer Font Test!"];
    [lib windowsfont:30 y:170 height:32 rotation:0 style:0 withUnderline:0 fontName:@"Arial" content:@"中文Englishにほンゴ한국어"];
    //fontName: Please refer to "iosfonts.com"
    
    [lib barcode:@"30" y:@"300" barcodeType:@"39" height:@"70" readable:@"1" rotation:@"0" narrow:@"2" wide:@"6" code:@"12345"];
     
    //Download PCX
    NSBundle *mainBunle = [NSBundle mainBundle];
    NSString *absolutePath = [mainBunle pathForResource:@"UL" ofType:@"pcx"];
    [lib downloadPCX:absolutePath asName:@"UL.PCX"];
    [lib sendCommand:@"PUTPCX 300,250,\"UL.PCX\"\r\n"];

    [lib printlabel:@"1" copies:@"1"];
    [lib closeport:4.0];
    
    [self.commandDelegate sendPluginResult:CDVCommandStatus_OK callbackId:callBackId];
}
@end
