﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Hardware.Usb;
using Android.Content;
using System.Linq;

using tsclib;
using System.Text;

namespace usbtest
{
    [Activity(Label = "usbtest", MainLauncher = true, Icon = "@drawable/icon")]

    //[BroadcastReceiver(Enabled = true)]
    //[IntentFilter(new[] { UsbManager.ActionUsbDeviceAttached, UsbManager.ActionUsbDeviceDetached })]
    //[MetaData(UsbManager.ActionUsbDeviceAttached, Resource = "@xml/device_filter")]
    //[MetaData(UsbManager.ActionUsbDeviceDetached, Resource = "@xml/device_filter")]


    public class MainActivity : Activity
    {
        private static string ACTION_USB_PERMISSION = "com.tscprinters.android";
        private Button button1;
        private TextView tv1;

        private static UsbManager mUsbManager;
        private static UsbDevice mUsbDevice;
        private static PendingIntent mPermissionIntent;

        tsclib.usb usb = new tsclib.usb();

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);
            // Set our view from the "main" layout resource
             SetContentView (Resource.Layout.Main);

            mUsbManager = (UsbManager)this.GetSystemService(Context.UsbService);
            var matchingDevice = mUsbManager.DeviceList.FirstOrDefault(item => item.Value.VendorId == 4611 || item.Value.ProductId == 37022);
            var usbPort = matchingDevice.Key;
            mUsbDevice = matchingDevice.Value;
            mPermissionIntent = PendingIntent.GetBroadcast(this, 0, new Intent(ACTION_USB_PERMISSION), 0);
            mUsbManager.RequestPermission(mUsbDevice, mPermissionIntent);
            
            tv1 = FindViewById<TextView>(Resource.Id.textView1);
            button1 = FindViewById<Button>(Resource.Id.button1);
            button1.Click += delegate { send(); };


        }


        private void send()
        {
            usb.openport(mUsbManager, mUsbDevice);
            
            usb.sendcommand("SIZE 50 mm, 30 mm\r\n");
            usb.sendcommand("GAP 0 mm, 0 mm\r\n");
            usb.sendcommand("DIRECTION 1\r\n");
            usb.sendcommand("CLS\r\n");
            usb.sendcommand("TEXT 100,100,\"3\",0,1,1,\"123456\"\r\n");
            usb.sendcommand("PRINT 1\r\n");

        }
        


    }
}

