//
//  ViewController.m
//  TSCSample
//
//  Created by Muta Huang on 14/07/2017.
//  Copyright © 2017 TSC. All rights reserved.
//

#import "ViewController.h"
#include "TSCSDK.h"

TSCSDK *lib;
NSMutableArray* deviceList;
CBPeripheral* CP;
NSString *TargetName;

@interface ViewController ()

@end

@implementation ViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    lib = [TSCSDK new];
    deviceList = [lib searchBLEDevice: 2];
}



- (IBAction)send:(UIButton *)sender
{
    
    for(int i=0;i<deviceList.count;i++)
    {
        //NSLog(@"peripheral\n%@\n",deviceList[i]);
        if([((CBPeripheral *)deviceList[i]).name isEqualToString:@"Alpha-3R"])//BLE NAME
        {
            [lib openportBLE:((CBPeripheral *)deviceList[i])];
        }
    }
    
    //NSData *status = [lib printer_status];
    //0x00:Normal, 0x01:Head opened, 0x10:Pause
    
    [lib sendCommand:@"DIRECION 1\r\n"];
    //[lib setup:@"100" height:@"120" speed:@"4" density:@"10" sensor:@"0" vertical:@"2" offset:@"0"];
    [lib sendCommand:@"SIZE 100 mm, 120 mm\r\n"];
    [lib sendCommand:@"SPEED 4\r\n"];
    [lib sendCommand:@"DENSITY 10\r\n"];
    [lib sendCommand:@"GAP 2 mm, 0 mm\r\n"];
    //[lib sendCommand:@"BLINE 2 mm, 0 mm\r\n"];
    
    [lib clearBuffer];
    
    //Using downloaded font to print text
    /*[lib sendCommand:@"CODEPAGE UTF-8\r\n"];
     [lib sendCommand_utf8:@"TEXT 30,30,\"ARIALUNI.TTF\",0,8,8,\"中文Englishにほンゴ한국어\"\r\n"];*/
    [lib sendCommand:@"TEXT 30,30,\"2\",0,2,2,\"1234567\"\r\n"];
    [lib printerfont:@"30" y:@"100" fontName:@"2" rotation:@"0" magnificationRateX:@"2" magnificationRateY:@"2" content:@"Printer Font Test!"];
    //[lib windowsfont:30 y:170 height:32 rotation:0 style:0 withUnderline:0 fontName:@"Arial" content:@"中文Englishにほンゴ한국어"];
    //fontName: Please refer to "iosfonts.com"
    
    [lib barcode:@"30" y:@"300" barcodeType:@"39" height:@"70" readable:@"1" rotation:@"0" narrow:@"2" wide:@"6" code:@"12345"];
    
    //Download PCX
    /*NSBundle *mainBunle = [NSBundle mainBundle];
    NSString *absolutePath = [mainBunle pathForResource:@"UL" ofType:@"pcx"];
    [lib downloadPCX:absolutePath asName:@"UL.PCX"];
    [lib sendCommand:@"PUTPCX 300,250,\"UL.PCX\"\r\n"];*/
    
    [lib printlabel:@"1" copies:@"1"];
    
    [lib closeport:2.0];
    //[lib closeport:10.0]; //With Windowsfont
    //[lib closeport:30.0]; //With Windowsfont & downloadPCX
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
