//
//  ViewController.m
//  TSCSample
//
//  Created by Muta Huang on 14/07/2017.
//  Copyright © 2017 TSC. All rights reserved.
//

#import "ViewController.h"
@import TSCFramework;
@interface ViewController ()
@property (weak, nonatomic) IBOutlet UITextView *textArea;

@end
TSCSDK *lib;
@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    lib = [TSCSDK new];
    // Do any additional setup after loading the view, typically from a nib.
}

- (IBAction)send:(UIButton *)sender
{
    _textArea.text = @"";
        __block int Count = 0;
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            @try {
                while (true) {
                    Count++;
                    if([lib openportMFI:@"com.issc.datapath"] == 1)
                    {
                        //[lib sendCommand:@"FEED 1\r\n"];
                        NSString *hexString = [self hexStringFromData:[lib printer_status]];
                        
                        dispatch_async(dispatch_get_main_queue(), ^{
                            _textArea.text = [NSString stringWithFormat:@"%@Status: %@\r\n", _textArea.text, hexString];
                        });

                        [lib closeport:1.0];

                        dispatch_async(dispatch_get_main_queue(), ^{
                            _textArea.text = [_textArea.text stringByAppendingString:[NSString stringWithFormat:@"Action %d Success\r\n", Count]];
                            // 强制刷新界面
                            [_textArea setNeedsDisplay];
                        });
                    }
                    else
                    {
                        dispatch_async(dispatch_get_main_queue(), ^{
                            _textArea.text = [_textArea.text stringByAppendingString:[NSString stringWithFormat:@"Failed to connect. Please check your MFI connection\r\n", Count]];
                            // 强制刷新界面
                            [_textArea setNeedsDisplay];
                        });
                    }

                    [NSThread sleepForTimeInterval:3];
                }
            } @catch (NSException *exception) {
                NSLog(@"Failed: %d", Count);
                NSLog(@"%@", exception);
                dispatch_async(dispatch_get_main_queue(), ^{
                    _textArea.text = [NSString stringWithFormat:@"%@\r\nFailed: %d\r\n%@", _textArea.text, Count, exception];
                });
            } @finally {
            }
        });
    
    /*
    [lib openportMFI:@"com.issc.datapath"];
    [lib clearBuffer];
    [lib sendCommand:@"DIRECION 1\r\n"];
    //[lib setup:@"100" height:@"120" speed:@"4" density:@"10" sensor:@"0" vertical:@"2" offset:@"0"];
    [lib sendCommand:@"SIZE 100 mm, 120 mm\r\n"];
    [lib sendCommand:@"SPEED 4\r\n"];
    [lib sendCommand:@"DENSITY 10\r\n"];
    [lib sendCommand:@"GAP 0 mm, 0 mm\r\n"];
    //[lib sendCommand:@"BLINE 2 mm, 0 mm\r\n"];
    
    //Using downloaded font to print text
    [lib sendCommand:@"CODEPAGE UTF-8\r\n"];
    [lib printerfont:@"30" y:@"100" fontName:@"2" rotation:@"0" magnificationRateX:@"2" magnificationRateY:@"2" content:@"Printer Font Test!"];
    [lib windowsfont:30 y:170 height:32 rotation:0 style:0 withUnderline:0 fontName:@"Arial" content:@"中文Englishにほンゴ한국어"];
    //fontName: Please refer to "iosfonts.com"
    
    [lib barcode:@"30" y:@"300" barcodeType:@"39" height:@"70" readable:@"1" rotation:@"0" narrow:@"2" wide:@"6" code:@"12345"];
     
    [lib printlabel:@"1" copies:@"1"];
    [lib closeport:4.0];
*/
}

- (NSString *)hexStringFromData:(NSData *)data {
    const unsigned char *dataBytes = (const unsigned char *)[data bytes];
    NSMutableString *hexString = [NSMutableString stringWithCapacity:[data length] * 4];
    
    for (NSUInteger i = 0; i < [data length]; i++) {
        [hexString appendFormat:@"0x%02x", dataBytes[i]];
        if (i < [data length] - 1) {
            [hexString appendString:@" "]; // 添加空格分隔符
        }
    }
    
    return [NSString stringWithString:hexString];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
